PROGRAM gpsro_driver

IMPLICIT NONE


INTEGER, PARAMETER :: nlev=38       ! no. of p levels in state vec.
INTEGER, PARAMETER :: nobs=110      ! initially assume 250 m spacing 
REAL :: roc
REAL :: undul
REAL :: lat
REAL :: pres(nlev),temp(nlev),q(nlev)
REAL :: pres_prime(nlev),temp_prime(nlev),q_prime(nlev)
REAL :: zg(nlev)
REAL :: a(nobs)
REAL :: alpha(nobs),alpha_prime(nobs)
REAL :: alpha1(nobs),alpha2(nobs)
REAL :: pres2(nlev),temp2(nlev),q2(nlev)



INTEGER :: i


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! THIS DATA SHOULD BE REPLACED WITH THE UM MODEL INPUT 
!
! set the atmospheric profile parameters easy values, to get the code
! ruuning. This is where the UM data should go in.  

! set latitude to arb. value = 45 degrees

lat = 45.0

! set profile data

DO i = 1,nlev

! level height

   zg(i) = REAL(i)*1000.0

! pres (hPa)
   
   pres(i) = 1013.0*EXP(-zg(i)/6000.0)

   pres_prime(i) = 0.001*pres(i)

   pres2(i) = pres(i)+pres_prime(i)


! temp (K)
   
   temp(i) = 270.0   ! isothermal for simplicity

   temp2(i) = temp(i) + temp_prime(i)

! Specific humidity (g/kg)   

   q(i) = 10.0*EXP(-zg(i)/1500.0)
      
   q_prime(i) = 0.01*q(i)   
   
   q2(i) = q(i) + q_prime(i) 
   
      
ENDDO   

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!    
!
! I DON'T THINK YOU'LL NEED TO CHANGE THESE VALUES FOR THE STUDY
! THEY SHOULD BE A REASONABLE STARTING POINT
!
! Now set the observation "impact heights". We'll assume that the observation
! profile is always on a set of fixed impact heights, with a 250 m spacing.
!    
! impact height = impact parameter - radius of curvature
!
! 
! radius of curvature 

roc = 6371000.0  ! set to mean radius of earth. OK for this study.  

undul = 0.0      ! ok for this study

DO i = 1, nobs

   a(i) = roc + 3000.0+REAL(i-1)*250.0 

ENDDO
! 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

! The routine that forward models the bending angles 

CALL alpha_optl(nlev,   &   ! no. of model levs (=38)
              nobs,   &   ! no. of bending angles in profile
	      roc,    &   ! radius of curv. 
	      undul,  &   ! undulation (set to 0.0)
	      lat,    &   ! latitude of ob. location (degrees)
	      pres,   &   ! pressure on mod levels (hPa)
	      pres_prime, &
	      temp,   &   ! temp on model levels
	      temp_prime, &
	      q,      &   ! specific humidity (g/kg)
	      q_prime, &
	      zg,     &   ! geopotential height of model levels (m)
	      a,      &   ! impact parameters
	      alpha, &     ! **OUTPUT** bending angles PROFILE
	      alpha_prime)      ! **OUTPUT** bending angle perts PROFILE


CALL alpha_op(nlev,   &   ! no. of model levs (=38)
              nobs,   &   ! no. of bending angles in profile
	      roc,    &   ! radius of curv. 
	      undul,  &   ! undulation (set to 0.0)
	      lat,    &   ! latitude of ob. location (degrees)
	      pres,   &   ! pressure on mod levels (hPa)
	      temp,   &   ! temp on model levels
	      q,      &   ! specific humidity (g/kg)
	      zg,     &   ! geopotential height of model levels (m)
	      a,      &   ! impact parameters
	      alpha1)      ! **OUTPUT** bending angles PROFILE



CALL alpha_op(nlev,   &   ! no. of model levs (=38)
              nobs,   &   ! no. of bending angles in profile
	      roc,    &   ! radius of curv. 
	      undul,  &   ! undulation (set to 0.0)
	      lat,    &   ! latitude of ob. location (degrees)
	      pres2,   &   ! pressure on mod levels (hPa)
	      temp2,   &   ! temp on model levels
	      q2,      &   ! specific humidity (g/kg)
	      zg,     &   ! geopotential height of model levels (m)
	      a,      &   ! impact parameters
	      alpha2)      ! **OUTPUT** bending angles PROFILE



DO i = 1,nobs

   write (6,'(i4,3e16.6)') i,a(i)-roc,alpha_prime(i),(alpha2(i)-alpha1(i))
   
ENDDO   


END
