PROGRAM gpsro_driver

IMPLICIT NONE


INTEGER, PARAMETER :: nlev=38       ! no. of p levels in state vec.
INTEGER, PARAMETER :: nobs=110      ! initially assume 250 m spacing 
REAL :: roc
REAL :: undul
REAL :: lat
REAL :: pres(nlev),temp(nlev),q(nlev)
REAL :: zg(nlev)
REAL :: a(nobs)
REAL :: alpha(nobs)

INTEGER :: i


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! THIS DATA SHOULD BE REPLACED WITH THE UM MODEL INPUT 
!
! set the atmospheric profile parameters easy values, to get the code
! ruuning. This is where the UM data should go in.  

! set latitude to arb. value = 45 degrees

lat = 45.0

! set profile data

DO i = 1,nlev

! level height

   zg(i) = REAL(i)*1000.0

! pres (hPa)
   
   pres(i) = 1013.0*EXP(-zg(i)/6000.0)

! temp (K)
   
   temp(i) = 270.0   ! isothermal for simplicity

! Specific humidity (g/kg)   

   q(i) = 10.0*EXP(-zg(i)/1500.0)
      
ENDDO   

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!    
!
! I DON'T THINK YOU'LL NEED TO CHANGE THESE VALUES FOR THE STUDY
! THEY SHOULD BE A REASONABLE STARTING POINT
!
! Now set the observation "impact heights". We'll assume that the observation
! profile is always on a set of fixed impact heights, with a 250 m spacing.
!    
! impact height = impact parameter - radius of curvature
!
! 
! radius of curvature 

roc = 6371000.0  ! set to mean radius of earth. OK for this study.  

undul = 0.0      ! ok for this study

DO i = 1, nobs

   a(i) = roc + 3000.0+REAL(i-1)*250.0 

ENDDO
! 
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

! The routine that forward models the bending angles 

CALL alpha_op(nlev,   &   ! no. of model levs (=38)
              nobs,   &   ! no. of bending angles in profile
	      roc,    &   ! radius of curv. 
	      undul,  &   ! undulation (set to 0.0)
	      lat,    &   ! latitude of ob. location (degrees)
	      pres,   &   ! pressure on mod levels (hPa)
	      temp,   &   ! temp on model levels
	      q,      &   ! specific humidity (g/kg)
	      zg,     &   ! geopotential height of model levels (m)
	      a,      &   ! impact parameters
	      alpha)      ! **OUTPUT** bending angles PROFILE

write (6,*) 'alpha'

DO i = 1,nobs

   write (6,*) i,a(i)-roc,alpha(i)
   
ENDDO   


END
