MODULE refrac_info

IMPLICIT NONE

LOGICAL, PARAMETER :: check_hum = .FALSE. 
INTEGER, PARAMETER :: ITMAX = 50
REAL, PARAMETER  :: delta   = 0.01
REAL, PARAMETER  :: R       = 287.05
REAL, PARAMETER  :: CP      = 1005.0
REAL, PARAMETER  :: kappa   = R/CP
REAL, PARAMETER  :: Pref    = 1000.0 
REAL, PARAMETER  :: Epsilon = 0.62198
REAL, PARAMETER  :: C_virtual = 1.0E-3*(1.0/Epsilon - 1.0)
REAL, PARAMETER  :: aval    = 77.6
REAL, PARAMETER  :: bval    = 3.73E5
REAL, PARAMETER  :: g       = 9.80665
REAL, PARAMETER  :: RMDI    = -9999.0
REAL, PARAMETER  :: Rog     = R/g
REAL, PARAMETER  :: pi      = 3.14159
REAL, PARAMETER  :: root_pi = 1.77245
REAL, PARAMETER  :: big_diff = 0.02

! for check_input

REAL, PARAMETER  :: ref_min = 1.0E-3
REAL, PARAMETER  :: ref_max = 500.0
REAL, PARAMETER  :: alpha_min = -1.0E-3
REAL, PARAMETER  :: alpha_max = 0.1
REAL, PARAMETER  :: a_min = 6.2E6
REAL, PARAMETER  :: a_max = 6.5E6 
REAL, PARAMETER  :: zg_min = 0.0
REAL, PARAMETER  :: zg_max = 1.0E5
REAL, PARAMETER  :: T_min = 150.0
REAL, PARAMETER  :: T_max = 350.0
REAL, PARAMETER  :: lnQ_min = -25.0
REAL, PARAMETER  :: lnQ_max =  4.0



TYPE Ob_type

   REAL            :: lat
   REAL            :: lon
   INTEGER         :: year
   INTEGER         :: doy
   INTEGER         :: ocnum
   REAL            :: roc
   INTEGER         :: nobs

   REAL,    POINTER :: a(:)
   REAL,    POINTER :: alpha(:) 
   REAL,    POINTER :: alpha_b(:)
   REAL,    POINTER :: alpha_s(:) 

   
END TYPE 


TYPE bg_type

   REAL            :: lat
   REAL            :: lon
   INTEGER         :: year
   INTEGER         :: doy
   INTEGER         :: ocnum
   REAL            :: pz0
   REAL            :: psurf
   INTEGER         :: nlev


   REAL,    POINTER :: pres(:)
   REAL,    POINTER :: temp(:) 
   REAL,    POINTER :: qval(:)

   
END TYPE 





END MODULE refrac_info


