
subroutine message(type, string, status)

!
! based on message.f90 of ROPP 4.0:
! modified by jmf for direct write to EGOPS *.log file;
!                 interim hack, proper implementation TBD
!


! Declarations
! ------------

  use messages, not_this => message


  implicit none

  interface
     function get_io_unit() result(unit)
       implicit none
       integer :: unit
     end function get_io_unit
  end interface


  integer,            intent(in) :: type
  character(len = *), intent(in) :: string
  integer,            optional   :: status

  integer                        :: stat
  integer                        :: idx
  character(len = 2024)          :: post, xstring
  character(len = 1024)          :: ropp_msg_mode

  integer                        :: logFileLrn
  character(len = *), parameter  :: logStrPrepend = ' ROPP '


! Read ROPP_MSG_MODE environment variable to set msg_MODE level

  IF (.NOT. msg_MODE_READ) THEN
    CALL GETENV( "ROPP_MSG_MODE", ropp_msg_mode)
    SELECT CASE (TRIM(ropp_msg_mode))
    CASE ("QuietMode")
      msg_MODE = QuietMode
    CASE ("NormalMode")
      msg_MODE = NormalMode
    CASE ("VerboseMode")
      msg_MODE = VerboseMode
    END SELECT
    msg_MODE_READ = .true.
  ENDIF

! Exit status
! -----------

  if (present(status)) then
     stat = status
  else
     stat = -1
  endif

! Set names of program and routine
! --------------------------------

  if (len_trim(msg_program) == 0) then
     if (len_trim(msg_routine) == 0) then
        if (len_trim(msg_addinfo) == 0) then
           post = ':'
        else
           post = ' (' // trim(msg_addinfo) // '):'
        endif
     else
        if (len_trim(msg_addinfo) == 0) then
           post = ' (from ' // trim(msg_routine) // '):'
        else
           post = ' (from ' // trim(msg_routine) // '/' // &
                               trim(msg_addinfo) // '):'
        endif
     endif
  else
     if (len_trim(msg_routine) == 0) then
        if (len_trim(msg_addinfo) == 0) then
           post = ' (from ' // trim(msg_program) // '):'
        else
           post = ' (from ' // trim(msg_program) // '/' // &
                               trim(msg_addinfo) // '):'
        endif
     else
        if (len_trim(msg_addinfo) == 0) then
           post = ' (from ' // trim(msg_program) // '/' // &
                               trim(msg_routine) // '):'
        else
           post = ' (from ' // trim(msg_program) // '/' // &
                               trim(msg_routine) // '/' // &
                               trim(msg_addinfo) // '):'
        endif
     endif
  endif


  if (msg_logFile(1:1) /= ' ') then

     ! -----------------------------------
     ! Ignore control characters in string
     ! -----------------------------------

     xstring = string

     do
        idx = INDEX(trim(xstring),'\a')
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(32)
     enddo
     do
        idx = INDEX(trim(xstring),'\b')
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(32)
     enddo
     do
        idx = INDEX(trim(xstring),'\t')
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(32)
     enddo
     do
        idx = INDEX(trim(xstring),'\n')
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(32)
     enddo
     do
        idx = INDEX(trim(xstring), "\'")
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(32)
     enddo
     do
        idx = INDEX(trim(xstring),'\"')
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(32)
     enddo
     do
        idx = INDEX(trim(xstring),'\\')
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(32)
     enddo

     ! -----------------
     ! Log error message
     ! -----------------

     logFileLrn = get_io_unit()
     open(logFileLrn, file=msg_logFile, status='unknown', position='append')

     select case(type)
     case(msg_cont)
       IF (msg_MODE >= NormalMode)   &
          write(logFileLrn, '(a)') logStrPrepend // '   ' // trim(xstring)
     case(msg_diag)
       IF (msg_MODE == VerboseMode)   &
          write(logFileLrn, '(a)') logStrPrepend // '...' // trim(post) // '  ' // trim(xstring)
     case(msg_info)
          write(logFileLrn, '(a)') logStrPrepend // 'INFO' // trim(post) // '  ' // trim(xstring)
     case(msg_warn)
       IF (msg_MODE >= NormalMode) THEN
         write(logFileLrn, '(a)') logStrPrepend // 'WARNING' // trim(post) // '  ' // trim(xstring)
       ENDIF
     case(msg_error)
       IF (msg_MODE >= QuietMode) THEN
          write(logFileLrn, '(a)') logStrPrepend // 'ERROR' // trim(post) // '  ' // trim(xstring)
        ENDIF
      case(msg_fatal)
       IF (msg_MODE >= QuietMode) THEN
         write(logFileLrn, '(a)') logStrPrepend // 'FATAL ERROR' // trim(post) // '  ' // trim(xstring)
       ENDIF
       close(logFileLrn)
       call exit(stat)
     case(msg_noin)
       IF (msg_MODE >= NormalMode)   &
          write(logFileLrn, '(a)') logStrPrepend // trim(xstring)
     end select

     close(logFileLrn)
     return

  else

     ! -----------------------------------
     ! Handle control characters in string
     ! -----------------------------------

     xstring = string                       

     do
        idx = INDEX(trim(xstring),'\a')
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(07)
     enddo
     do
        idx = INDEX(trim(xstring),'\b')
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(08)
     enddo
     do
        idx = INDEX(trim(xstring),'\t')
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(09)
     enddo
     do
        idx = INDEX(trim(xstring),'\n')
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(10)
     enddo
     do
        idx = INDEX(trim(xstring), "\'")
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(39)
     enddo
     do
        idx = INDEX(trim(xstring),'\"')
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(34)
     enddo
     do
        idx = INDEX(trim(xstring),'\\')
        if(idx == 0) exit
        xstring(idx:idx+1) = achar(92)
     enddo

     ! -------------------
     ! Print error message
     ! -------------------

     select case(type)
     case(msg_cont)
       IF (msg_MODE >= NormalMode)   &
          write(stdout, '(a)')  '   ' // trim(xstring)
     case(msg_diag)
       IF (msg_MODE == VerboseMode)   &
          write(stdout, '(a)') '...' // trim(post) // '  ' // trim(xstring)
     case(msg_info)
       IF (msg_MODE >= NormalMode)   &
          write(stdout, '(a)') 'INFO' // trim(post) // '  ' // trim(xstring)
     case(msg_warn)
       IF (msg_MODE >= NormalMode) THEN
         write(stderr, '(a)') ' '
         write(stdout, '(a)') 'WARNING' // trim(post) // '  ' // trim(xstring)
       ENDIF
     case(msg_error)
       IF (msg_MODE >= QuietMode) THEN
          write(stderr, '(a)') ' '
          write(stderr, '(a)') 'ERROR' // trim(post) // '  ' // trim(xstring)
        ENDIF
      case(msg_fatal)
       IF (msg_MODE >= QuietMode) THEN
         write(stderr, '(a)') ' '
         write(stderr, '(a)') 'FATAL ERROR' // trim(post) // '  ' // trim(xstring)
         write(stderr, '(a)') ' '
       ENDIF
       call exit(stat)
     case(msg_noin)
       IF (msg_MODE >= NormalMode)   &
          write(stdout, '(a)') trim(xstring)
     end select

   end if

end subroutine message



module messages

!
! based on messages.f90 of ROPP 4.0:
! modified by jmf for direct write to EGOPS *.log file;
!                 interim hack, proper implementation TBD
!

!--------------------------------------------------------------------------
! 1. Declarations
!--------------------------------------------------------------------------

  implicit none

!--------------------------------------------------------------------------
! 2. Preconnected logical unit numbers
!--------------------------------------------------------------------------

  integer, parameter :: stdin  = 5
  integer, parameter :: stdout = 6
  integer, parameter :: stderr = 0

!--------------------------------------------------------------------------
! 2. Error types
!--------------------------------------------------------------------------

  integer, parameter, public :: msg_cont  = z'00'
  integer, parameter, public :: msg_info  = z'01'
  integer, parameter, public :: msg_diag  = z'03'
  integer, parameter, public :: msg_warn  = z'02'
  integer, parameter, public :: msg_error = z'04'
  integer, parameter, public :: msg_fatal = z'08'
  integer, parameter, public :: msg_noin  = z'10'

!--------------------------------------------------------------------------
! 3. Global private variables
!--------------------------------------------------------------------------

  character(len = 1024)       :: msg_program = ''
  character(len = 1024)       :: msg_routine = ''
  character(len = 1024)       :: msg_addinfo = ''
  character(len = 1024), save :: msg_logFile = ''

!---------------------------------------------------------------------------
! 4. Operational/Debug mode definitions 
!---------------------------------------------------------------------------

!****ip* Initialisation/msg_MODE
!
! NAME
!    msg_MODE - Internal global operating mode definitions 
!
! NOTES
!    This parameter controls the level of output diagnostic information
!    output by ROPP routines. This parameter may be used to selectively define 
!    required output messages from within sub-routines, or define the 
!    appropriate level of info/warning/error message output to print from 
!    ropp_messages library.
!
!    The available options are:
!       QuietMode  - only output error messages to stderr, no info/warnings
!       NormalMode - output all info and warnings to stdout, errors to stderr
!       VerboseMode - as NormalMode, but also output diagnostic/debug messages
!                     as specified within an individual subroutine.
!    
!    The required msg_MODE may be altered either within a program routine, e.g.
!               msg_MODE = VerboseMode                ! Enable all messages
!               CALL message(msg_diag, "The result is....")
!               msg_MODE = NormalMode                 ! Re-set to normal level
!    or by implicitly setting the default value below and re-compiling, or by
!    setting the environment variable ROPP_MSG_MODE on the command line. The 
!    environment variable is checked the first time the messages library is
!    called from within a program (and flag msg_MODE_READ is set to TRUE to 
!    prevent further reading of the environment variable on subsequent calls).
!    Any further change to msg_MODE from within a program takes precendent over
!    the environment variable setting, which itself preceeds the default 
!    setting in this module at compile-time.
!
! SOURCE
!
  INTEGER, PARAMETER, public :: QuietMode   = 0
  INTEGER, PARAMETER, public :: NormalMode  = 10
  INTEGER, PARAMETER, public :: VerboseMode = 20  

  INTEGER                    :: msg_MODE = NormalMode

  LOGICAL, SAVE, public      :: msg_MODE_READ = .false. 
!
!****

!--------------------------------------------------------------------------
! 5. Interfaces
!--------------------------------------------------------------------------

  interface message
     subroutine message(type, string, status)
       integer,            intent(in) :: type
       character(len = *), intent(in) :: string
       integer,            optional   :: status
     end subroutine message
  end interface

  interface assert
     subroutine assert(condition, string, severity)
         logical,            intent(in) :: condition
         character(len = *), intent(in) :: string
         integer,            optional   :: severity
       end subroutine assert
    end interface


contains


   subroutine message_set_logFile(logFileName)

     implicit none

     character(len = *), intent(in) :: logFileName


     msg_logFile = logFileName

   end subroutine message_set_logFile


   subroutine message_get_roppVersion(roppMajorNumber, roppMinorNumber, roppReleaseNumber, roppErrorCode) 

      integer, intent(out) :: roppMajorNumber     
      integer, intent(out) :: roppMinorNumber     
      integer, intent(out) :: roppReleaseNumber     
      integer, intent(out) :: roppErrorCode     

      roppMajorNumber   = 4
      roppMinorNumber   = 0
      roppReleaseNumber = 1
      roppErrorCode     = 0  

   end subroutine message_get_roppVersion


end module messages
