#!/bin/bash
#
# NAME:
# ropp_svn_install.sh
#
# DESCRIPTION:
# This script configures, builds, and installs ROPP when checked out from SVN. 
# It assumes that the user has SVN copies of ropp_src and ropp_bld in 
# directories given by the $ROPP_SRC and $ROPP_BLD environment variables,
# respectively. It checks if environment variables are set. It is intended 
# as a help for the development team at DMI, and uses the ifort compiler.
# Executables and libraries are put in $ROPP_ROOT/ifort. The script can 
# be run from any directory.
#
# AUTHOR:
# Stig Syndergaard
#

# Check for environment variables.

echo "Checking for environment variables..."
echo ""
if [ -n "$ROPP_SRC" ] ; then
  echo "Your ROPP_SRC environment variable is set to: "
  echo "$ROPP_SRC" 
  echo "This is where you should have a copy of ropp_src from SVN."
  echo ""
else
  echo "Failed: Please set the ROPP_SRC environment variable "
  echo "to the path where you have checked out ropp_src from SVN."
  exit 0
fi

if [ -n "$ROPP_BLD" ] ; then
  echo "Your ROPP_BLD environment variable is set to: "
  echo "$ROPP_BLD"
  echo "This is where you should have a copy of ropp_bld from SVN."
  echo "Dependency packages (e.g. NetCDF and BUFR tar-balls) "
  echo "should be located here as well."
  echo ""
else
  echo "Failed: Please set the ROPP_BLD environment variable "
  echo "to the path where you have checked out ropp_bld from SVN."
  exit 0
fi

if [ -n "$ROPP_ROOT" ] ; then
  echo "Your ROPP_ROOT environment variable is set to $ROPP_ROOT"
  echo "After installation, executables and libraries will be located here."
  echo ""
else
  echo "Failed: Please set the ROPP_ROOT environment variable "
  echo "to the path where you want ROPP executables to be installed."
  exit 0
fi

echo "Ready to install [Y/N]?"
read ANSWER
if [[ ! $ANSWER = Y ]] ; then
  echo "Nothing done."
  exit 0
fi

# Go for it!

echo "Installing dependencies using the ifort compiler..."
echo ""
echo "cd $ROPP_BLD"
cd $ROPP_BLD
echo "build_deps ifort"
build_deps ifort
echo ""

echo "Configuring, building, and installing ROPP using the ifort compiler..."
echo ""
echo "cd $ROPP_SRC"
cd $ROPP_SRC
echo "$ROPP_BLD/roppauto"
$ROPP_BLD/roppauto
echo "$ROPP_BLD/roppconfig -c ifort -i $ROPP_ROOT -m"
$ROPP_BLD/roppconfig -c ifort -i $ROPP_ROOT -m
echo ""
echo "Done! Check files for successful installation."

exit 0
