#!/bin/sh
#
# Test the multi-bufr tool bufr2ropp
#

ROPP_ROOT=/data/users/idculv/ROPP

#comp=gfortran
#comp=ifort17
comp=nagfor61

exec1=bufr2ropp
exec2=ropp2bufr
exec3=eum2bufr

mobufr_lib=$ROPP_ROOT/$comp/lib64/libmetdbbufr.a

ecbufr_lib=$ROPP_ROOT/$comp/lib/libbufr.a

eccodes_lib1=$ROPP_ROOT/$comp/lib64/libeccodes.a
eccodes_lib2=$ROPP_ROOT/$comp/lib64/libeccodes_f90.a


for mobufr in 1 ; do

  if [ $mobufr -eq 0 ] ; then
    mv  $mobufr_lib ${mobufr_lib/libmetdbbufr/.libmetdbbufr}
  else
    mv ${mobufr_lib/libmetdbbufr/.libmetdbbufr} $mobufr_lib
  fi

  for ecbufr in 1 ; do

    if [ $ecbufr -eq 0 ] ; then
      mv  $ecbufr_lib ${ecbufr_lib/libbufr/.libbufr}
    else
      mv ${ecbufr_lib/libbufr/.libbufr} $ecbufr_lib
    fi

    for eccodes in 1 ; do

      if [ $eccodes -eq 0 ] ; then
        mv $eccodes_lib1 ${eccodes_lib1/libeccodes/.libeccodes}
        mv $eccodes_lib2 ${eccodes_lib2/libeccodes/.libeccodes}
      else
        mv ${eccodes_lib1/libeccodes/.libeccodes} $eccodes_lib1
        mv ${eccodes_lib2/libeccodes/.libeccodes} $eccodes_lib2
      fi

      ofile=${PWD}/test4_${mobufr}${ecbufr}${eccodes}_${comp}.out

      echo \$comp \$mobufr \$ecbufr \$eccodes = $comp $mobufr $ecbufr $eccodes

      echo \$comp \$mobufr \$ecbufr \$eccodes = \$comp $mobufr $ecbufr $eccodes > $ofile 2>&1

      rm ${exec1} ${exec1}_mobufr ${exec1}_ecbufr ${exec1}_eccodes
      rm ${exec2} ${exec2}_mobufr ${exec2}_ecbufr ${exec2}_eccodes
      rm ${exec3} ${exec3}_mobufr ${exec3}_ecbufr ${exec3}_eccodes

      cd ../

      ../configure/ropp_configure_${comp}_linux  >> $ofile  2>&1

      cd tools

      make clean >> $ofile 2>&1

      make install >> $ofile 2>&1

      ls -ltr ${exec1}*  |tail >> $ofile 2>&1
      ls -ltr ${exec2}*  |tail >> $ofile 2>&1
      ls -ltr ${exec3}*  |tail >> $ofile 2>&1

      cd ../tests

      make clean >> $ofile 2>&1

      make >> $ofile 2>&1

      make test >> $ofile 2>&1

      cd ../tools

    done

  done

done

