program stdiotest
! Test use of F90 I/O stream unit 0 as equivalent to C stderr output
! Compile with:
!  $ FF -o stdio stdio.f90
! where FF is a Fortran-90/95 compiler (e.g. ifort, pg95, gfortran...)
! Run with:
!  $ stdio               # should write text to screen twice (stdout & stderr)
!  $ stdio 2> errfile    # should write text to screen once (stdout only)
!                             and write text to errfile once (stderr only)
!  $ cat errfile
!
   integer, parameter :: stdout = 6
   integer, parameter :: stderr = 0

   write ( unit=stdout, fmt='(a)' ) '... This is stdout ...'
   write ( unit=stderr, fmt='(a)' ) '### This is stderr ###'
end program stdiotest