#!/bin/bash

fclist="g95 gfortran \
        ifort ifort11 ifort12 ifort13 ifort14 \
        nagfor pgf95 pgf11 sunf95 xlf95"
ncomps=0
nfailed=0
for FF in $fclist; do
  which $FF >/dev/null 2>&1
  if [[ $? -ne 0 ]]; then continue; fi
  ((ncomps++))
  rm -f stdiotest errfile
  echo "-----------------------------------------"
  echo $FF
  $FF -o stdiotest stdiotest.f90
  if [[ -x stdiotest ]]; then
    echo
    echo "TEST 1: stdout & stderr to screen:"
    stdiotest
    echo
    echo "TES 2: stdout to screen & stderr to file:"
    stdiotest 2> errfile
    echo "errfile content:"
    cat errfile
    line=$(cat errfile)
    if [[ $line == '### This is stderr ###' ]]; then
      echo "=== PASS ==="
    else
      echo "*** FAILED stderr file test***"
      ((nfailed++))
    fi
  else
    echo "** FAILED to compile test program ***"
    ((nfailed++))
  fi
done
echo "-----------------------------------------"
echo "$nfailed failed out of $ncomps compilers tested "
exit
