#/usr/bin/ksh
#
# Script to test effect of changing CO to C0 for COSMIC IDs in
# ropp_io/bufr/roppbufrcodes.nl and ropp_io/bufr/convertcodes.f90.
# Ref #376.
#
# IDC, 25/7/2014.
#

IFILE0=ucar_test.nc


# -------------------
# Cntl: ROPP6.1 ifort
# -------------------

NLFILE=roppbufrcodes_old.nl

TOOL=ropp_io/tools/ucar2ropp

EXEC=/data/nwp1/idculv/ROPP/ropp_src/branches/dev/Share/ROPP61_prototype/$TOOL

IFILE=$IFILE0

OFILE=`echo $IFILE |sed -es/'.nc'/'_cntl.nc'/`

TFILE=`echo $IFILE |sed -es/'.nc'/'_cntl.out'/`

echo "cp $NLFILE /data/nwp1/idculv/ROPP/data/bufr/roppbufrcodes.nl > $TFILE"
echo "cp $NLFILE /data/nwp1/idculv/ROPP/data/bufr/roppbufrcodes.nl" > $TFILE
      cp $NLFILE /data/nwp1/idculv/ROPP/data/bufr/roppbufrcodes.nl >> $TFILE

echo "$EXEC  $IFILE  -o $OFILE  -d  >> $TFILE"
echo "$EXEC  $IFILE  -o $OFILE  -d"  >> $TFILE
      $EXEC  $IFILE  -o $OFILE  -d  >> $TFILE

echo "ncdump -h $IFILE |grep fileStamp >> $TFILE"
echo "ncdump -h $IFILE |grep fileStamp" >> $TFILE
      ncdump -h $IFILE |grep fileStamp >> $TFILE

echo "ncks -H -vleo_id $OFILE >> $TFILE"
echo "ncks -H -vleo_id $OFILE" >> $TFILE
      ncks -H -vleo_id $OFILE >> $TFILE


TOOL=ropp_io/tools/ropp2bufr

EXEC=/data/nwp1/idculv/ROPP/ropp_src/branches/dev/Share/ROPP61_prototype/$TOOL

IFILE=$OFILE

OFILE=`echo $IFILE |sed -es/'.nc'/'.bufr'/`

echo "$EXEC  $IFILE  -o $OFILE  -d  >> $TFILE"
echo "$EXEC  $IFILE  -o $OFILE  -d"  >> $TFILE
      $EXEC  $IFILE  -o $OFILE  -d  >> $TFILE


echo "$ROPP_ROOT/ifort/bin/decbufr -d $OFILE |grep SATELLITE >> $TFILE"
echo "$ROPP_ROOT/ifort/bin/decbufr -d $OFILE |grep SATELLITE" >> $TFILE
      $ROPP_ROOT/ifort/bin/decbufr -d $OFILE |grep SATELLITE >> $TFILE


# --------------
# Test1: ROPP8.0
# --------------

NLFILE=roppbufrcodes_new.nl

TOOL=ropp_io/tools/ucar2ropp

EXEC=/data/nwp1/idculv/ROPP/ropp_src/branches/dev/Share/ROPP80_prototype/$TOOL

IFILE=$IFILE0

OFILE=`echo $IFILE |sed -es/'.nc'/'_test.nc'/`

TFILE=`echo $IFILE |sed -es/'.nc'/'_test.out'/`

echo "cp $NLFILE /data/nwp1/idculv/ROPP/data/bufr/roppbufrcodes.nl > $TFILE"
echo "cp $NLFILE /data/nwp1/idculv/ROPP/data/bufr/roppbufrcodes.nl" > $TFILE
      cp $NLFILE /data/nwp1/idculv/ROPP/data/bufr/roppbufrcodes.nl >> $TFILE

echo "$EXEC  $IFILE  -o $OFILE  -d  >> $TFILE"
echo "$EXEC  $IFILE  -o $OFILE  -d"  >> $TFILE
      $EXEC  $IFILE  -o $OFILE  -d  >> $TFILE

echo "ncdump -h $IFILE |grep fileStamp >> $TFILE"
echo "ncdump -h $IFILE |grep fileStamp" >> $TFILE
      ncdump -h $IFILE |grep fileStamp >> $TFILE

echo "ncks -H -vleo_id $OFILE >> $TFILE"
echo "ncks -H -vleo_id $OFILE" >> $TFILE
      ncks -H -vleo_id $OFILE >> $TFILE

TOOL=ropp_io/tools/ropp2bufr

EXEC=/data/nwp1/idculv/ROPP/ropp_src/branches/dev/Share/ROPP80_prototype/$TOOL

IFILE=$OFILE

OFILE=`echo $IFILE |sed -es/'.nc'/'.bufr'/`

echo "$EXEC  $IFILE  -o $OFILE  -d  >> $TFILE"
echo "$EXEC  $IFILE  -o $OFILE  -d"  >> $TFILE
      $EXEC  $IFILE  -o $OFILE  -d  >> $TFILE


echo "$ROPP_ROOT/ifort/bin/decbufr -d $OFILE |grep SATELLITE >> $TFILE"
echo "$ROPP_ROOT/ifort/bin/decbufr -d $OFILE |grep SATELLITE" >> $TFILE
      $ROPP_ROOT/ifort/bin/decbufr -d $OFILE |grep SATELLITE >> $TFILE

