#/usr/bin/ksh
#
# Script to examine effect on eum2ropp and eum2bufr of putting the reference POD 
# in new variables, r_leo_ref etc, instead of length 1 dim_levla variables r_leo.
#

IFILE0=eum_test.n4

#OPTION=''  ;  ID=0
#OPTION='-b'  ;  ID=1
OPTION='-l cl+rs'  ;  ID=2

#-------------------------
#0. Cntl: ROPP9.0 eum2ropp
#-------------------------

TOOL=eum2ropp

EXEC=/net/data/nwp1/idculv/ROPP/ropp_src/branches/dev/Share/ROPP90_prototype/ropp_io/tools/$TOOL

IFILE=$IFILE0

NFILE=$(echo $IFILE0 |sed -es/".n4"/"_cntl${ID}.nc"/)

TFILE=$(echo $IFILE0 |sed -es/".n4"/"_cntl${ID}.out"/)

echo "$EXEC  $OPTION  $IFILE  -o $NFILE  -d   > $TFILE 2>&1"
echo "$EXEC  $OPTION  $IFILE  -o $NFILE  -d"  > $TFILE 2>&1
      $EXEC  $OPTION  $IFILE  -o $NFILE  -d  >> $TFILE 2>&1

banner "RESULTS OF eum2ropp $(echo $OPTION| sed -es/'-'/'_'/g)"  >> $TFILE 2>&1

echo "ncdump -h $NFILE | head -15  >> $TFILE 2>&1"
echo "ncdump -h $NFILE | head -15" >> $TFILE 2>&1
      ncdump -h $NFILE | head -15  >> $TFILE 2>&1

echo "ncks -H -ddim_lev1a,0 -vr_leo $NFILE  >> $TFILE 2>&1"
echo "ncks -H -ddim_lev1a,0 -vr_leo $NFILE" >> $TFILE 2>&1
      ncks -H -ddim_lev1a,0 -vr_leo $NFILE  >> $TFILE 2>&1

echo "ncks -H -vr_leo_ref $NFILE  >> $TFILE 2>&1"
echo "ncks -H -vr_leo_ref $NFILE" >> $TFILE 2>&1
      ncks -H -vr_leo_ref $NFILE  >> $TFILE 2>&1

# Convert to BUFR

TOOL=ropp2bufr

EXEC=/net/data/nwp1/idculv/ROPP/ropp_src/branches/dev/Share/ROPP90_prototype/ropp_io/tools/$TOOL

BFILE=$(echo $IFILE0 |sed -es/".n4"/"_cntl${ID}.bfr"/)

echo "$EXEC  $NFILE  -o $BFILE  -d  >> $TFILE 2>&1"
echo "$EXEC  $NFILE  -o $BFILE  -d" >> $TFILE 2>&1
      $EXEC  $NFILE  -o $BFILE  -d  >> $TFILE 2>&1

banner "RESULTS OF eum2ropp $(echo $OPTION| sed -es/'-'/'_'/g) | ropp2bufr" >> $TFILE 2>&1

echo "decbufr -d $BFILE | grep 'DISTANCE FROM THE' |head -3  >> $TFILE 2>&1"
echo "decbufr -d $BFILE | grep 'DISTANCE FROM THE' |head -3" >> $TFILE 2>&1
      decbufr -d $BFILE | grep 'DISTANCE FROM THE' |head -3  >> $TFILE 2>&1

# Compare eum2bufr and eum2ropp | ropp2bufr

TOOL=eum2bufr

EXEC=/net/data/nwp1/idculv/ROPP/ropp_src/branches/dev/Share/ROPP90_prototype/ropp_io/tools/$TOOL

BFILE2=$(echo $IFILE0 |sed -es/".n4"/"_cntl${ID}.bfr2"/)

echo "$EXEC  $IFILE0  -o $BFILE2  -d  >> $TFILE 2>&1"
echo "$EXEC  $IFILE0  -o $BFILE2  -d" >> $TFILE 2>&1
      $EXEC  $IFILE0  -o $BFILE2  -d  >> $TFILE 2>&1

banner "RESULTS OF eum2bufr" >> $TFILE 2>&1

echo "decbufr -d $BFILE2 | grep 'DISTANCE FROM THE' |head -3  >> $TFILE 2>&1"
echo "decbufr -d $BFILE2 | grep 'DISTANCE FROM THE' |head -3" >> $TFILE 2>&1
      decbufr -d $BFILE2 | grep 'DISTANCE FROM THE' |head -3  >> $TFILE 2>&1

# Compare eum2ropp and eum2bufr | bufr2ropp

TOOL=bufr2ropp

EXEC=/net/data/nwp1/idculv/ROPP/ropp_src/branches/dev/Share/ROPP90_prototype/ropp_io/tools/$TOOL

NFILE2=$(echo $IFILE0 |sed -es/".n4"/"_cntl${ID}.nc2"/)

echo "$EXEC  $BFILE2  -o $NFILE2  -d  >> $TFILE 2>&1"
echo "$EXEC  $BFILE2  -o $NFILE2  -d" >> $TFILE 2>&1
      $EXEC  $BFILE2  -o $NFILE2  -d  >> $TFILE 2>&1

banner "RESULTS OF eum2bufr | bufr2ropp" >> $TFILE 2>&1

echo "ncdump -h $NFILE2 | head -15  >> $TFILE 2>&1"
echo "ncdump -h $NFILE2 | head -15" >> $TFILE 2>&1
      ncdump -h $NFILE2 | head -15  >> $TFILE 2>&1

echo "ncks -H -ddim_lev1a,0 -vr_leo $NFILE2  >> $TFILE 2>&1"
echo "ncks -H -ddim_lev1a,0 -vr_leo $NFILE2" >> $TFILE 2>&1
      ncks -H -ddim_lev1a,0 -vr_leo $NFILE2  >> $TFILE 2>&1

echo "ncks -H -vr_leo_ref $NFILE2  >> $TFILE 2>&1"
echo "ncks -H -vr_leo_ref $NFILE2" >> $TFILE 2>&1
      ncks -H -vr_leo_ref $NFILE2  >> $TFILE 2>&1


#---------------------------
#1. Test: ic_refpod eum2ropp
#---------------------------

TOOL=eum2ropp

EXEC=/net/data/nwp1/idculv/ROPP/ropp_src/branches/dev/Share/ic_refpod/ropp_io/tools/$TOOL

IFILE=$IFILE0

NFILE=$(echo $IFILE0 |sed -es/".n4"/"_test${ID}.nc"/)

TFILE=$(echo $IFILE0 |sed -es/".n4"/"_test${ID}.out"/)

echo "$EXEC  $OPTION  $IFILE  -o $NFILE  -d   > $TFILE 2>&1"
echo "$EXEC  $OPTION  $IFILE  -o $NFILE  -d"  > $TFILE 2>&1
      $EXEC  $OPTION  $IFILE  -o $NFILE  -d  >> $TFILE 2>&1

banner "RESULTS OF eum2ropp $(echo $OPTION| sed -es/'-'/'_'/g)" >> $TFILE 2>&1

echo "ncdump -h $NFILE | head -15  >> $TFILE 2>&1"
echo "ncdump -h $NFILE | head -15" >> $TFILE 2>&1
      ncdump -h $NFILE | head -15  >> $TFILE 2>&1

echo "ncks -H -ddim_lev1a,0 -vr_leo $NFILE  >> $TFILE 2>&1"
echo "ncks -H -ddim_lev1a,0 -vr_leo $NFILE" >> $TFILE 2>&1
      ncks -H -ddim_lev1a,0 -vr_leo $NFILE  >> $TFILE 2>&1

echo "ncks -H -vr_leo_ref $NFILE  >> $TFILE 2>&1"
echo "ncks -H -vr_leo_ref $NFILE" >> $TFILE 2>&1
      ncks -H -vr_leo_ref $NFILE  >> $TFILE 2>&1

# Now convert to BUFR

TOOL=ropp2bufr

EXEC=/net/data/nwp1/idculv/ROPP/ropp_src/branches/dev/Share/ic_refpod/ropp_io/tools/$TOOL

BFILE=$(echo $IFILE0 |sed -es/".n4"/"_test${ID}.bfr"/)

echo "$EXEC  $NFILE  -o $BFILE  -d  >> $TFILE 2>&1"
echo "$EXEC  $NFILE  -o $BFILE  -d" >> $TFILE 2>&1
      $EXEC  $NFILE  -o $BFILE  -d  >> $TFILE 2>&1

banner "RESULTS OF eum2ropp $(echo $OPTION| sed -es/'-'/'_'/g) | ropp2bufr" >> $TFILE 2>&1

echo "decbufr -d $BFILE | grep 'DISTANCE FROM THE' |head -3  >> $TFILE 2>&1"
echo "decbufr -d $BFILE | grep 'DISTANCE FROM THE' |head -3" >> $TFILE 2>&1
      decbufr -d $BFILE | grep 'DISTANCE FROM THE' |head -3  >> $TFILE 2>&1

# Compare eum2bufr and eum2ropp | ropp2bufr

TOOL=eum2bufr

EXEC=/net/data/nwp1/idculv/ROPP/ropp_src/branches/dev/Share/ic_refpod/ropp_io/tools/$TOOL

BFILE2=$(echo $IFILE0 |sed -es/".n4"/"_test${ID}.bfr2"/)

echo "$EXEC  $IFILE0  -o $BFILE2  -d  >> $TFILE 2>&1"
echo "$EXEC  $IFILE0  -o $BFILE2  -d" >> $TFILE 2>&1
      $EXEC  $IFILE0  -o $BFILE2  -d  >> $TFILE 2>&1

banner "RESULTS OF eum2bufr" >> $TFILE 2>&1

echo "decbufr -d $BFILE2 | grep 'DISTANCE FROM THE' |head -3  >> $TFILE 2>&1"
echo "decbufr -d $BFILE2 | grep 'DISTANCE FROM THE' |head -3" >> $TFILE 2>&1
      decbufr -d $BFILE2 | grep 'DISTANCE FROM THE' |head -3  >> $TFILE 2>&1

# Compare eum2ropp and eum2bufr | bufr2ropp

TOOL=bufr2ropp

EXEC=/net/data/nwp1/idculv/ROPP/ropp_src/branches/dev/Share/ic_refpod/ropp_io/tools/$TOOL

NFILE2=$(echo $IFILE0 |sed -es/".n4"/"_test${ID}.nc2"/)

echo "$EXEC  $BFILE2  -o $NFILE2  -d  >> $TFILE 2>&1"
echo "$EXEC  $BFILE2  -o $NFILE2  -d" >> $TFILE 2>&1
      $EXEC  $BFILE2  -o $NFILE2  -d  >> $TFILE 2>&1

banner "RESULTS OF eum2bufr | bufr2ropp" >> $TFILE 2>&1

echo "ncdump -h $NFILE2 | head -15  >> $TFILE 2>&1"
echo "ncdump -h $NFILE2 | head -15" >> $TFILE 2>&1
      ncdump -h $NFILE2 | head -15  >> $TFILE 2>&1

echo "ncks -H -ddim_lev1a,0 -vr_leo $NFILE2  >> $TFILE 2>&1"
echo "ncks -H -ddim_lev1a,0 -vr_leo $NFILE2" >> $TFILE 2>&1
      ncks -H -ddim_lev1a,0 -vr_leo $NFILE2  >> $TFILE 2>&1

echo "ncks -H -vr_leo_ref $NFILE2  >> $TFILE 2>&1"
echo "ncks -H -vr_leo_ref $NFILE2" >> $TFILE 2>&1
      ncks -H -vr_leo_ref $NFILE2  >> $TFILE 2>&1
