! $Id: roppbufrcodes.nl 5557 2018-08-06 09:34:03Z idculv $
!---------------------------------------------------------------
! NAMELIST file for ROPP BUFR encoder/decoder
!---------------------------------------------------------------
! Add new pairs of alpha-numeric character ID and associated
! BUFR code to the following lists to extend the known IDs to
! the ROPP/BUFR applications. The first pair should always be
! values for 'missing' or 'unknown' IDs.
!
! This file (roppbufrcodes.nl) should be installed to the
! directory path defined by environment variable BUFR_TABLES
! (for use with ECMWF BUFR library) and/or BUFR_LIBRARY for use
! with Met Office/MetDB BUFR library).
!---------------------------------------------------------------
!
! List of GNSS Tx Classes & their BUFR codes (Code Table 002020)
!
&GNScodes
GNSlist = "U",      "G", "R", "E", "C"     ! [GPS, GLONASS, Galileo, Beidou(/Compass)]
GNScode = -9999999, 401, 402, 403, 404
/
!
! List of LEO Rx IDs & their BUFR codes (Code Table 001007 CCT C-5)
! and associated Instrument Type code   (Code Table 002019 CCT C-8)
! NB: MetOp-A .eqv. MetOp-2, -B <=> -1 and -C <=> -3.
! NB: instrument code 104 (Tri-G) for COSMIC-2 and GRACE-FO is provisional
!
&LEOcodes
LEOlist = "UNKN",  "OERS", "CHMP", "SUNS", "SACC",
                   "GRAA", "GRAB", "GRAC", "GRAD",
                   "C001", "C002", "C003",
                   "C004", "C005", "C006",
                   "META", "METB", "METC", "TSRX",
                   "TDMX", "PAZE", "OSAT", "CNOF",
                   "MGTP", "FY3C", "FY3D", "KOM5",
                   "C2E1", "C2E2", "C2E3",
                   "C2E4", "C2E5", "C2E6",
                   "C2P1", "C2P2", "C2P3",
                   "C2P4", "C2P5", "C2P6"
LEOcode = -9999999, 040,    041,    800,    820,
                    722,    723,    803,    804,
                    740,    741,    742,
                    743,    744,    745,
                    004,    003,    005,    042,
                    043,    044,    421,    786,
                    440,    522,    523,    825,
                    750,    751,    752,
                    753,    754,    755,
                    724,    725,    726,
                    727,    728,    729
InsCode = -9999999, 102,    102,    102,    102,
                    102,    102,    104,    104,
                    102,    102,    102,
                    102,    102,    102,
                    202,    202,    202,    103,
                    103,    103,    287,    102,
                    287,    958,    958,    103,
                    104,    104,    104,
                    104,    104,    104,
                    104,    104,    104,
                    104,    104,    104
/
!
! List of (BUFR) Originating Centre IDs & their BUFR codes
! (Code Table 001033, CCT C-1, or 001035, CCT C-11)
! The (Processing) Sub-centre code should be valid for the
! associated Originating Centre code (for which Sub-Centre is 0).
! (Code Table 001034, CCT C-12)
! plus associated ICAO Location Indicator codes (for GTS routing headers)
! (ICAO Document 7910: Location Indicators)
! NB: Origin code 'CMA' for FY-3C is provisional
! NB: Origin code 'ISRO' for Megha-Tropiques is provisional
!
&ORGcodes
ORGlist = "UNKNOWN", "DMI", "GFZ", "METO", "UCAR", "NESDIS", "EUMETSAT", "CMA", "ISRO"
ORGcode = -9999999,    094,   078,    074,    060,      160,        254,   038,    028
Subcode = -9999999,    000,   173,    000,    000,      000,        000,   000,    000
ORGname = " ",
          "(ROM SAF)",
          "Helmholtz Centre, Potsdam",
          "Met Office, Exeter",
          "Boulder",
          "Washington",
          "Darmstadt",
          "Beijing",
          "New Delhi"
ICAOcode = "ZZZZ",  "EKMI", "EDZW", "EGRR", "KWBC", "KNES", "EUMS", "BAWX", "DEMS"
/
!
! List of Background Generating centres & their BUFR codes.
! (Code Table 001033, CCT C-1, or 001033, CCT C-11)
!
&BGDcodes
BGDlist = "UNKNOWN", "ECMWF", "DMI", "METO", "NCEP", "CMA", "ISRO"
BGDcode =  -9999999,     098,   094,    074,    007,   038,    028
/
!
!End -----------------------------------------------------------
