#/usr/bin/ksh
#
# Script to compare ROPP9.0 and ROPP9.1 versions of ucar2ropp
# on CDAAC Metop data
#

ulimit -S -s unlimited

IFILE0=data/atmPhs_C001.2017.001.14.15.G08_0001.0001_nc
IFILE0=data/atmPhs_MTPA.2017.001.00.04.G29_2016.0120_nc
IFILE0=data/occ20160608_235011_M01_2260600399_N0023_XXXX.nc

#------------------------------------------------------
#0. Cntl: ROPP9.0
#------------------------------------------------------

#if false ; then  #  bypass the control

EXEC_DIR=$ROPP_ROOT/ropp_src/branches/dev/Share/ROPP90_prototype/ropp_io/tools

TOOL=ucar2ropp  ;  EXEC=$EXEC_DIR/$TOOL

IFILE=$IFILE0

OFILE=$(echo $IFILE0 |sed -es/'.nc'/'_cntl1.nc'/)

TFILE=$(echo $IFILE0 |sed -es/'.nc'/'_cntl1.out'/)  ;  rm -f $TFILE

echo "$EXEC  $IFILE  -o $OFILE  -d  >> $TFILE 2>&1"
      $EXEC  $IFILE  -o $OFILE  -d  >> $TFILE 2>&1


EXEC_DIR=$ROPP_ROOT/ropp_src/branches/dev/Share/ROPP90_prototype/ropp_pp/tools

TOOL=ropp_pp_occ_tool  ;  EXEC=$EXEC_DIR/$TOOL

IFILE=$OFILE

CFILE=data/gras_pp.cf

MFILE=data/MSIS_coeff.nc

OFILE=$(echo $IFILE0 |sed -es/'.nc'/'_occ_cntl1.nc'/)

echo "$EXEC  $IFILE  -c $CFILE  -mfile $MFILE  -o $OFILE  -d >> $TFILE"
      $EXEC  $IFILE  -c $CFILE  -mfile $MFILE  -o $OFILE  -d >> $TFILE

#fi  #  bypass the control

#------------------------------------------------------
#1. Test: ROPP9.1
#------------------------------------------------------

#if false ; then  #  bypass the test

EXEC_DIR=$ROPP_ROOT/ropp_src/branches/dev/Share/ROPP91_prototype/ropp_io/tools

TOOL=ucar2ropp  ;  EXEC=$EXEC_DIR/$TOOL

IFILE=$IFILE0

OFILE=$(echo $IFILE0 |sed -es/'.nc'/'_test1.nc'/)

TFILE=$(echo $IFILE0 |sed -es/'.nc'/'_test1.out'/)  ;  rm -f $TFILE

echo "$EXEC  $IFILE  -o $OFILE  -d  >> $TFILE 2>&1"
      $EXEC  $IFILE  -o $OFILE  -d  >> $TFILE 2>&1

EXEC_DIR=$ROPP_ROOT/ropp_src/branches/dev/Share/ROPP91_prototype/ropp_pp/tools

TOOL=ropp_pp_occ_tool  ;  EXEC=$EXEC_DIR/$TOOL

IFILE=$OFILE

CFILE=data/gras_pp.cf

MFILE=data/MSIS_coeff.nc

OFILE=$(echo $IFILE0 |sed -es/'.nc'/'_occ_test1.nc'/)

echo "$EXEC  $IFILE  -c $CFILE  -mfile $MFILE  -o $OFILE  -d >> $TFILE"
      $EXEC  $IFILE  -c $CFILE  -mfile $MFILE  -o $OFILE  -d >> $TFILE

#fi  #  bypass the test
