#!/bin/sh
# Run ropp_1dvar_bangle on Stig's RE1 examples

ulimit -S -s unlimited

obs_file=data/atm_20160101_000028_METB_G021_R_2305_0010.nc

#bgr_file=data/bgf_20160101_000028_METB_G021_R_2305_0010.nc # 60L
#bgr_covfile=data/ropp_bg_ses_ecmwf_error_corr_L60.nc

bgr_file=data/bgo_20160101_000028_METB_G021_R_2305_0010.nc  # 137L
bgr_covfile=data/ropp_bg_ses_ecmwf_error_corr_L137.nc

config_file=data/ecmwf_refrac_1dvar.cf

#-------------------------------------------------------------------------------
# 0. ROPP9.0 CNTL
#-------------------------------------------------------------------------------

#if false ; then

exec_base=/data/users/idculv/ROPP/ropp_src/branches/dev/Share/ROPP90_prototype/ropp_1dvar

txt_file=$(echo $bgr_file |sed -es/'.nc'/'_cntl.txt'/)  ;  rm $txt_file  ;  touch $txt_file


# Add obs errors (default obs proc = VSDC)
# ----------------------------------------

obs_file1=$(echo $obs_file |sed -es/'0010.nc'/'0010a_cntl.nc'/)

exec=$exec_base/errors/ropp_1dvar_add_refrac_error

echo "$exec  $obs_file  -Omod MO  -o $obs_file1  >> $txt_file 2>&1"
      $exec  $obs_file  -Omod MO  -o $obs_file1  >> $txt_file 2>&1


# Add bgr errors (default obs proc = VSFC)
# ----------------------------------------

bgr_file1=$(echo $bgr_file |sed -es/'0010.nc'/'0010a_cntl.nc'/)

exec=$exec_base/errors/ropp_1dvar_add_bgr_error

echo "$exec  $bgr_file  -c $bgr_covfile  -o $bgr_file1  >> $txt_file 2>&1"
      $exec  $bgr_file  -c $bgr_covfile  -o $bgr_file1  >> $txt_file 2>&1


# Run 1dvar
# ---------

out_file=$(echo $bgr_file |sed -es/'.nc'/'_cntl.nc'/)

echo "ncks -H -Q -vyear,month,day,hour,minute,second $obs_file1  >> $txt_file 2>&1"
echo "ncks -H -Q -vyear,month,day,hour,minute,second $obs_file1" >> $txt_file 2>&1
      ncks -H -Q -vyear,month,day,hour,minute,second $obs_file1  >> $txt_file 2>&1

echo "ncks -H -Q -vyear,month,day,hour,minute,second $bgr_file1  >> $txt_file 2>&1"
echo "ncks -H -Q -vyear,month,day,hour,minute,second $bgr_file1" >> $txt_file 2>&1
      ncks -H -Q -vyear,month,day,hour,minute,second $bgr_file1  >> $txt_file 2>&1

echo "ncks -H -Q -vbg_year,bg_month,bg_day,bg_hour,bg_minute,bg_fcperiod $bgr_file1  >> $txt_file 2>&1"
echo "ncks -H -Q -vbg_year,bg_month,bg_day,bg_hour,bg_minute,bg_fcperiod $bgr_file1" >> $txt_file 2>&1
      ncks -H -Q -vbg_year,bg_month,bg_day,bg_hour,bg_minute,bg_fcperiod $bgr_file1  >> $txt_file 2>&1

exec=$exec_base/tools/ropp_1dvar_refrac

echo "$exec  -y $obs_file1  -b $bgr_file1  --bg-corr $bgr_covfile  -c $config_file  -d  -o $out_file >> $txt_file 2>&1"
      $exec  -y $obs_file1  -b $bgr_file1  --bg-corr $bgr_covfile  -c $config_file  -d  -o $out_file >> $txt_file 2>&1


#fi


#-------------------------------------------------------------------------------
# 1. ROPP9.1 TEST
#-------------------------------------------------------------------------------

exec_base=/data/users/idculv/ROPP/ropp_src/branches/dev/Share/ROPP91_prototype/ropp_1dvar

txt_file=$(echo $bgr_file |sed -es/'.nc'/'_test.txt'/)  ;  rm $txt_file  ;  touch $txt_file


# Add obs errors (default obs proc = VSDC)
# ----------------------------------------

obs_file1=$(echo $obs_file |sed -es/'0010.nc'/'0010a_test.nc'/)

exec=$exec_base/errors/ropp_1dvar_add_refrac_error

echo "$exec  $obs_file  -Omod MO  -o $obs_file1  >> $txt_file 2>&1"
      $exec  $obs_file  -Omod MO  -o $obs_file1  >> $txt_file 2>&1


# Add bgr errors (default obs proc = VSFC)
# ----------------------------------------

bgr_file1=$(echo $bgr_file |sed -es/'0010.nc'/'0010a_test.nc'/)

exec=$exec_base/errors/ropp_1dvar_add_bgr_error

echo "$exec  $bgr_file  -c $bgr_covfile  -o $bgr_file1  >> $txt_file 2>&1"
      $exec  $bgr_file  -c $bgr_covfile  -o $bgr_file1  >> $txt_file 2>&1


# Run 1dvar
# ---------

out_file=$(echo $bgr_file |sed -es/'.nc'/'_test.nc'/)

echo "ncks -H -Q -vyear,month,day,hour,minute,second $obs_file1  >> $txt_file 2>&1"
echo "ncks -H -Q -vyear,month,day,hour,minute,second $obs_file1" >> $txt_file 2>&1
      ncks -H -Q -vyear,month,day,hour,minute,second $obs_file1  >> $txt_file 2>&1

echo "ncks -H -Q -vyear,month,day,hour,minute,second $bgr_file1  >> $txt_file 2>&1"
echo "ncks -H -Q -vyear,month,day,hour,minute,second $bgr_file1" >> $txt_file 2>&1
      ncks -H -Q -vyear,month,day,hour,minute,second $bgr_file1  >> $txt_file 2>&1

echo "ncks -H -Q -vbg_year,bg_month,bg_day,bg_hour,bg_minute,bg_fcperiod $bgr_file1  >> $txt_file 2>&1"
echo "ncks -H -Q -vbg_year,bg_month,bg_day,bg_hour,bg_minute,bg_fcperiod $bgr_file1" >> $txt_file 2>&1
      ncks -H -Q -vbg_year,bg_month,bg_day,bg_hour,bg_minute,bg_fcperiod $bgr_file1  >> $txt_file 2>&1

exec=$exec_base/tools/ropp_1dvar_refrac

echo "$exec  -y $obs_file1  -b $bgr_file1  --bg-corr $bgr_covfile  -c $config_file  -d  -o $out_file >> $txt_file 2>&1"
      $exec  -y $obs_file1  -b $bgr_file1  --bg-corr $bgr_covfile  -c $config_file  -d  -o $out_file >> $txt_file 2>&1


