#/usr/bin/ksh
#
# Script to test the ROPP9.0 version of in ropp_fm_bg2ro_1d.f90
#

TOOL=ropp_fm_bg2ro_1d
#EXEC=/data/nwp1/idculv/ROPP/ifort/bin/$TOOL
EXEC=/data/nwp1/idculv/ROPP/ifort17/bin/$TOOL


#IFILE=data/WOP_Study_Cases.nc
IFILE=data/WOP_Study_Cases_prof3.nc
#IFILE=data/WOP_Study_Cases_prof3_cntl1.nc
#IFILE=data/WOP_Study_Cases_prof3_test1.nc
#IFILE=data/WOP_Study_Cases_prof3_test2.nc
#IFILE=data/WOP_Study_Cases_prof3_test3.nc
#IFILE=data/WOP_Study_Cases_prof3_test4.nc
#IFILE=data/WOP_Study_Cases_prof3_test5.nc
#IFILE=data/WOP_Study_Cases_prof3_cntl1_cntl1.nc
#IFILE=data/WOP_Study_Cases_prof4.nc
#IFILE=data/WOP_Study_Cases_247L_prof4.nc
#IFILE=data/WOP_Study_Cases_247L_prof5.nc
#IFILE=data/WOP_Study_Cases_313L_prof5.nc
#IFILE=data/WOP_Study_Cases_prof10.nc
#IFILE=data/WOP_Study_Cases_prof12.nc
#IFILE=data/WOP_Study_Cases_prof17.nc
#IFILE=data/WOP_Study_Cases_prof18.nc
#IFILE=data/WOP_Study_Cases_prof22.nc
#IFILE=data/WOP_Study_Cases_prof37.nc
#IFILE=data/WOP_Study_Cases_prof49.nc


# Cntl1: 300L refrac and bangle

OFILE=`echo $IFILE |sed -es/'.nc'/'_cntl1.nc'/`
TFILE=`echo $IFILE |sed -es/'.nc'/'_cntl1.out'/`


echo "$EXEC  $IFILE  -o $OFILE  -d > $TFILE 2>&1 "
      $EXEC  $IFILE  -o $OFILE  -d > $TFILE 2>&1 

echo "ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/) "
      ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/)


# Cntl2: 300L refrac and bangle defined through default namelist

OFILE=`echo $IFILE |sed -es/'.nc'/'_cntl2.nc'/`
TFILE=`echo $IFILE |sed -es/'.nc'/'_cntl2.out'/`
CFILE=default_fm.nml

echo "$EXEC  $IFILE  -c $CFILE  -o $OFILE  -d > $TFILE 2>&1 "
      $EXEC  $IFILE  -c $CFILE  -o $OFILE  -d > $TFILE 2>&1 

echo "ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/) "
      ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/)


# Test1: 247L

OFILE=`echo $IFILE |sed -es/'.nc'/'_test1.nc'/`
TFILE=`echo $IFILE |sed -es/'.nc'/'_test1.out'/`
LFILE=$IFILE

echo "$EXEC  $IFILE  -247L  -o $OFILE  -d > $TFILE 2>&1 "
      $EXEC  $IFILE  -247L  -o $OFILE  -d > $TFILE 2>&1

echo "ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/) "
      ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/)


# Test2: refrac only

OFILE=`echo $IFILE |sed -es/'.nc'/'_test2.nc'/`
TFILE=`echo $IFILE |sed -es/'.nc'/'_test2.out'/`

echo "$EXEC  $IFILE  -refrac_only  -o $OFILE  -d > $TFILE 2>&1 "
      $EXEC  $IFILE  -refrac_only  -o $OFILE  -d > $TFILE 2>&1

echo "ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/) "
      ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/)


# Test3: bangle only

OFILE=`echo $IFILE |sed -es/'.nc'/'_test3.nc'/`
TFILE=`echo $IFILE |sed -es/'.nc'/'_test3.out'/`

echo "$EXEC  $IFILE  -bangle_only  -o $OFILE  -d > $TFILE 2>&1 "
      $EXEC  $IFILE  -bangle_only  -o $OFILE  -d > $TFILE 2>&1

echo "ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/) "
      ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/)


# Test4: 'best' config file

OFILE=`echo $IFILE |sed -es/'.nc'/'_test4.nc'/`
TFILE=`echo $IFILE |sed -es/'.nc'/'_test4.out'/`
#CFILE=test.nml
CFILE=best_fm.nml

echo "$EXEC  $IFILE  -c $CFILE  -o $OFILE  -d > $TFILE 2>&1 "
      $EXEC  $IFILE  -c $CFILE  -o $OFILE  -d > $TFILE 2>&1

echo "ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/) "
      ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/)


# Test5: 'best' options (should give the same results as Test4)

OFILE=`echo $IFILE |sed -es/'.nc'/'_test5.nc'/`
TFILE=`echo $IFILE |sed -es/'.nc'/'_test5.out'/`

echo "$EXEC  $IFILE  -best  -o $OFILE  -d > $TFILE 2>&1 "
      $EXEC  $IFILE  -best  -o $OFILE  -d > $TFILE 2>&1

echo "ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/) "
      ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/)


# Test6: read levels from a file

OFILE=`echo $IFILE |sed -es/'.nc'/'_test6.nc'/`
TFILE=`echo $IFILE |sed -es/'.nc'/'_test6.out'/`
LFILE=`echo $IFILE |sed -es/'.nc'/'_cntl1.nc'/`  # i.e. the 300L refrac and bangle

echo "$EXEC  $IFILE  -l $LFILE  -o $OFILE  -d > $TFILE 2>&1 "
      $EXEC  $IFILE  -l $LFILE  -o $OFILE  -d > $TFILE 2>&1

echo "ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/) "
      ncdump -h $OFILE > $(echo $OFILE |sed -es/'.nc'/'.nd'/)


exit
