#/usr/bin/ksh
#
# Script to measure the speedup of ROPP10 cf ROPP9.1 as a result of removing the 
# file synchronisation described in #554.
#

ulimit -S -s unlimited

IFILE0=data/IT-FM-07.nc  # 500 profiles
#IFILE0=data/IT-FM-04.nc  # 1000 profiles

#------------------------------------------------------
#0. Cntl: ROPP9.1
#------------------------------------------------------

#if false ; then  #  bypass the control

EXEC_DIR=$ROPP_ROOT/ropp_src/branches/dev/Share/ROPP91_prototype/ropp_fm/tools

TOOL=ropp_fm_bg2ro_1d  ;  EXEC=$EXEC_DIR/$TOOL

IFILE=$IFILE0

OFILE=$(echo $IFILE0 |sed -es/'.nc'/'_cntl1.nc'/)

TFILE=$(echo $IFILE0 |sed -es/'.nc'/'_cntl1.out'/)  ;  rm -f $TFILE

date >> $TFILE
for i in $(seq 1 5) ; do
  echo "\$i = $i"
  echo "\$i = $i" >> $TFILE 2>&1
  echo "$EXEC  $IFILE  -o $OFILE  -d  -f  >> $TFILE 2>&1"
        $EXEC  $IFILE  -o $OFILE  -d  -f  >> $TFILE 2>&1
done
date >> $TFILE

#fi  #  bypass the control

#------------------------------------------------------
#1. Test1: ROPP10.0
#------------------------------------------------------

#if false ; then  #  bypass the test

EXEC_DIR=$ROPP_ROOT/ropp_src/branches/dev/Share/ROPP100_prototype/ropp_fm/tools

TOOL=ropp_fm_bg2ro_1d  ;  EXEC=$EXEC_DIR/$TOOL

IFILE=$IFILE0

OFILE=$(echo $IFILE0 |sed -es/'.nc'/'_test1.nc'/)

TFILE=$(echo $IFILE0 |sed -es/'.nc'/'_test1.out'/)  ;  rm -f $TFILE

date >> $TFILE
for i in $(seq 1 5) ; do
  echo "\$i = $i"
  echo "\$i = $i" >> $TFILE 2>&1
  echo "$EXEC  $IFILE  -o $OFILE  -d  -f  >> $TFILE 2>&1"
        $EXEC  $IFILE  -o $OFILE  -d  -f  >> $TFILE 2>&1
done
date >> $TFILE

#fi  #  bypass the test

