#/usr/bin/ksh
#
# Script to test the 'old' and 'new' definitions of impact_height
# in the ROPP10.0 version of ucar2ropp
#

ulimit -S -s unlimited

IFILE0=data/atmPrf_C006.2019.213.00.21.G07_0001.0001_nc

#------------------------------------------------------
#0. Cntl: ROPP9.1
#------------------------------------------------------

#if false ; then  #  bypass the control

EXEC_DIR=$ROPP_ROOT/ropp_src/branches/dev/Share/ROPP91_prototype/ropp_io/tools

TOOL=ucar2ropp  ;  EXEC=$EXEC_DIR/$TOOL

IFILE=$IFILE0

OFILE=$(echo $IFILE0 |sed -es/'.nc'/'_cntl1.nc'/)

TFILE=$(echo $IFILE0 |sed -es/'.nc'/'_cntl1.out'/)  ;  rm -f $TFILE

echo "$EXEC  $IFILE  -o $OFILE  -d  >> $TFILE 2>&1"
      $EXEC  $IFILE  -o $OFILE  -d  >> $TFILE 2>&1

echo "ncks -H -Q -ddim_lev1b,0,4 -vimpact,undulation $OFILE" >> $TFILE
      ncks -H -Q -ddim_lev1b,0,4 -vimpact,undulation $OFILE  >> $TFILE

#fi  #  bypass the control

#------------------------------------------------------
#1. Test1: ROPP10.0 using 'old' definition
#------------------------------------------------------

#if false ; then  #  bypass the test

EXEC_DIR=$ROPP_ROOT/ropp_src/branches/dev/Share/ROPP100_prototype/ropp_io/tools

TOOL=ucar2ropp  ;  EXEC=$EXEC_DIR/$TOOL

IFILE=$IFILE0

OFILE=$(echo $IFILE0 |sed -es/'.nc'/'_test1.nc'/)

TFILE=$(echo $IFILE0 |sed -es/'.nc'/'_test1.out'/)  ;  rm -f $TFILE

echo "$EXEC  $IFILE  -o $OFILE  -x  -d  >> $TFILE 2>&1"
      $EXEC  $IFILE  -o $OFILE  -x  -d  >> $TFILE 2>&1

echo "ncks -H -Q -ddim_lev1b,0,4 -vimpact,undulation $OFILE" >> $TFILE
      ncks -H -Q -ddim_lev1b,0,4 -vimpact,undulation $OFILE  >> $TFILE

#fi  #  bypass the test

#------------------------------------------------------
#2. Test2: ROPP10.0 using 'new' definition
#------------------------------------------------------

#if false ; then  #  bypass the test

EXEC_DIR=$ROPP_ROOT/ropp_src/branches/dev/Share/ROPP100_prototype/ropp_io/tools

TOOL=ucar2ropp  ;  EXEC=$EXEC_DIR/$TOOL

IFILE=$IFILE0

OFILE=$(echo $IFILE0 |sed -es/'.nc'/'_test2.nc'/)

TFILE=$(echo $IFILE0 |sed -es/'.nc'/'_test2.out'/)  ;  rm -f $TFILE

echo "$EXEC  $IFILE  -o $OFILE  -d  >> $TFILE 2>&1"
      $EXEC  $IFILE  -o $OFILE  -d  >> $TFILE 2>&1

echo "ncks -H -Q -ddim_lev1b,0,4 -vimpact,undulation $OFILE" >> $TFILE
      ncks -H -Q -ddim_lev1b,0,4 -vimpact,undulation $OFILE  >> $TFILE

#fi  #  bypass the test
