#/usr/bin/ksh
#
# Script to rerun rose suite on it-pp-06, to compare against IDL version.

ulimit -S -s unlimited

#IFILE0=data/CASE_07_ref1d.nc
IFILE0=data/CASE_12_ref1d.nc
#IFILE0=data/CASE_05_ref1d.nc
#IFILE0=data/CASE_51_ref1d.nc

MFILE=data/MSIS_coeff.nc

CFILE=data/default_wopt.nml

THINFILE=data/ropp_thin_default.dat

# These two might need commenting out, as they were originally missing from the rose suite version.
GEOPOT_COEF=data/egm96.dat
GEOPOT_CORR=data/corrcoef.dat


#------------------------------------------------------
#0. Cntl: Rose
#------------------------------------------------------

#if false ; then  #  bypass the control

EXEC=/data/local/idculv/ropp_test_folder_02042019/gfortran/ropp_pp/tools/ropp_pp_wopt_tool

IFILE=$IFILE0

OFILE1=`echo $IFILE0 |sed -es/'.nc'/'_1.1.nc'/`

TFILE=`echo $IFILE0 |sed -es/'.nc'/'_rose.out'/`

echo "$EXEC  $IFILE  -o $OFILE1  -c $CFILE  -f  > $TFILE 2>&1"
      $EXEC  $IFILE  -o $OFILE1  -c $CFILE  -f  > $TFILE 2>&1

# Now some messy preparation for invert tool
ncrename  -vBangle_FSI,bangle  -ddim_009,dim_lev1b  $OFILE1
cmd="impact=Impact_height_FSI+6378137.0; lat_tp=impact*0.0; lon_tp=impact*0.0; azimuth_tp=impact*0.0; \
     impact_L1=impact; impact_L2=impact; bangle_L1=bangle; bangle_L2=bangle; \
     bangle_L1_sigma=impact*0.0; bangle_L2_sigma=impact*0.0; bangle_sigma=impact*0.0; \
     bangle_L1_qual=impact*0.0; bangle_L2_qual=impact*0.0; bangle_qual=impact*0.0"
ncap2  -s "$cmd"  $OFILE1  -O temp.nc
ncatted  -O  -a valid_range,impact,o,d,'-10000000., 10000000.'  temp.nc

EXEC=/data/local/idculv/ropp_test_folder_02042019/gfortran/ropp_io/tools/ropp2ropp

OFILE2=`echo $IFILE0 |sed -es/'.nc'/'_2.1.nc'/`

echo "$EXEC  temp.nc  -o $OFILE2  -d  -p $THINFILE  >> $TFILE 2>&1"
      $EXEC  temp.nc  -o $OFILE2  -d  -p $THINFILE  >> $TFILE 2>&1


# Now pass through invert to generate refracs and bangles
EXEC=/data/local/idculv/ropp_test_folder_02042019/gfortran/ropp_pp/tools/ropp_pp_invert_tool

OFILE=`echo $IFILE0 |sed -es/'.nc'/'.1.nc'/`

echo "$EXEC  $OFILE2  -m MSIS  -o $OFILE   >> $TFILE 2>&1"
      $EXEC  $OFILE2  -m MSIS  -o $OFILE   >> $TFILE 2>&1



#fi  #  bypass the control
