
#modules to read in which are generic python modules
import matplotlib.pyplot as plt
import netCDF4 as nc

#define location of data
dir = '/path/to/data/'

filename = 'eum_test.n4'
my_example_nc_file = dir + filename 

#read in data 
ds = nc.Dataset(my_example_nc_file, mode='r')

print(ds)
#find out what variables are in data
print(ds.groups['data']['level_1b'])

y=ds.groups['data']['level_1b']['thinned']['impact_height'][:]
x=ds.groups['data']['level_1b']['thinned']['bangle'][:]


plt.plot(x,y)

plt.xlabel('Bending Angle (rad)')
plt.ylabel('Impact Height (m)')
plt.yscale('log')
plt.show() #show plot

