
#modules to read in which are generic python modules
import matplotlib.pyplot as plt
import netCDF4 as nc

import collections
d = collections.OrderedDict()

#define location of data
dir = '/path/to/data/'
filename = 'IT-IO-03_o.nc'
my_example_nc_file = dir + filename 


ds = nc.Dataset(my_example_nc_file, mode='r')

# name the variables for plotting  
x = ds.variables['temp'][:] #extracts the temperature data
y = ds.variables['press'][:] #extracts the pressure data

x = x - 273.15 # Convert to degrees C

plt.plot(x[0],y[0])

plt.xlabel('Temperature (K)')
plt.ylabel('Pressure (hPa)')
plt.yscale('log')
plt.show() #show plot

