! prog=test14
! compilers="ifort17"
! compilers="gfortran ifort17 ifort16 nagfor61 pgf95 g95"
! for compiler in $(echo $compilers) ; do
!   echo $compiler -o ${prog}.exe ${prog}.f90
!   $compiler -o ${prog}.exe ${prog}.f90
!   echo ${prog}.exe
!   ./${prog}.exe
!   echo ""
! done
!
PROGRAM test14
!
! Purpose: To emulate mis-dimensioned K array, as seen in ROPP-11.
!

  IMPLICIT NONE

  INTEGER,  PARAMETER                   :: wp=KIND(1.D0)
  INTEGER,  PARAMETER                   :: m=3, n=2
  REAL(wp), DIMENSION(:,:), ALLOCATABLE :: K1, K2

! -------------------------------------------------------------------------

  ALLOCATE( K1(n, m), K2(m, n))

  print*,'SHAPE(K1) = ', SHAPE(K1)
  print*,'SHAPE(K2) = ', SHAPE(K2)

  K1(1, :) = (/ 1.0_wp, 2.0_wp, 3.0_wp /)
  K1(2, :) = (/ 4.0_wp, 5.0_wp, 6.0_wp /)

  print*,'K1 = ', K1

  K2 = K1  ! Let's see if this works

  print*,'SHAPE(K2) = ', SHAPE(K2)  ! redefined
  print*,'K2 = ', K2

  print*,'SHAPE( MATMUL(K1, TRANSPOSE(K2)) ) = ', &
          SHAPE( MATMUL(K1, TRANSPOSE(K2)) )! not defined if Ks keep their original shapes

  print*, 'MATMUL(K1, TRANSPOSE(K2)) = ', MATMUL(K1, TRANSPOSE(K2))
  
  DEALLOCATE (K2, K1)

END PROGRAM test14
